library(memisc)
library(magrittr)
source("me-syntactic-sugar.R") # Stuff, that will end up in `memisc` soon ...
load("gles2013work.RData")

gles2013work %$% codebook(ragelt18)
gles2013work %$% codebook(parteineigung)

# Nur Volljährige und
# Nachwahlumfrage, wo Parteineigung erfragt wurde
tmp <- subset(gles2013work,ragelt18==0 & parteineigung != -94 & geburt.jahr >= 1945)

dummyMatrix <- function(x) UseMethod("dummyMatrix")

dummyMatrix.factor <- function(x){
    D <- diag(nlevels(x))
    colnames(D) <- levels(x)
    j <- as.numeric(x)
    i <- seq_along(x)
    use <- is.finite(j)
    j <- j[use]
    i <- i[use]
    Y <- matrix(NA,nrow=length(x),ncol=ncol(D))
    colnames(Y) <- colnames(D)
    Y[i,] <- D[j,]
    return(Y)
}

dummyMatrix.item <- function(x){
    if(measurement(x) %in% c("nominal","ordinal"))
        dummyMatrix.factor(as.factor(x))
    else{
        warning("Won't create dummies unless item is nominal or ordinal")
        return(x)
    }
}

mat_pn <- dummyMatrix(tmp$parteineigung)
mat_pn %<>% colrename("CDU/CSU"="CDU.CSU")

mat_pnv <- dummyMatrix(tmp$partngvater)
mat_pnv %<>% colrename("CDU/CSU"="CDU.CSU")

mat_pnm <- dummyMatrix(tmp$partngmutter)
mat_pnm %<>% colrename("CDU/CSU"="CDU.CSU")

long.id <- rep(seq.int(nrow(tmp)),each=ncol(mat_pn))
gles2013workLong <- tmp[long.id,]


gles2013workLong %<>% within({
    id <- long.id                             %#% "Usprngl. position im Datensatz"
    partei <- rep(1:ncol(mat_pn)-1,nrow(tmp)) %#% "Partei für die Befr. Neigung hat oder nicht"
    labels(partei) <- structure(1:ncol(mat_pn)-1,
                                names=colnames(mat_pn))
    parneidum <- as.vector(t(mat_pn))         %#% "Parteineigung (Dummy) -- hat Befr. Neigung für Partei?"
    parneivadum <- as.vector(t(mat_pnv))      %#% "Parteineigung (Dummy) -- hat(te) Vater Neigung für Partei?"
    parneimudum <- as.vector(t(mat_pnm))      %#% "Parteineigung (Dummy) -- hat(te) Mutter Neigung für Partei?"
})

save(gles2013workLong,file="gles2013work-long.RData")
